# Present‑Act V2 — Collisional Decoherence (Boolean Which‑Path Marks)

This repo reproduces the simulation and results for **collisional decoherence via rare, boolean which‑path marks** in the Present‑Act V2.1 framework (purely boolean gates; equality fit; **PF/Born ties‑only**; no curves/weights). It generates the grid CSV, linear fits, summary JSON, and an audit JSON of guardrails.

> **Theory pins (V2.1)**: local neighbor acts, boolean/ordinal feasibility, equality fit on a finite alphabet, ratio‑lex accept, **PF/Born ties‑only**, canonical hinge measure, no‑skip composition, ticks = acts/M. Diagnostics are read‑only (no feedback into control).

## Quick start

```bash
# 1) Create a fresh environment (optional)
python -m venv .venv && . .venv/bin/activate  # Windows: .venv\Scripts\activate

# 2) Install deps
pip install -r requirements.txt

# 3) Run the sim (default seeds K=50k each; p and N sweeps; outputs/ created/overwritten)
python run.py --outdir outputs
```

Artifacts will appear in `outputs/`:

- `collisional_decoherence_grid.csv`
- `fit_fixedN.csv`
- `fit_fixedp.csv`
- `collisional_summary.json`

An audit file is written to `audits/audit.json` with guardrail booleans and a config hash. Pre‑generated outputs from the reference run are already in `outputs/` and `audits/` so you can inspect immediately.

## What the code does (succinct)

- **Mark generation:** per trial, a boolean *which‑path* mark is drawn with probability \(p_{\text{eff}}=1-(1-p)^N\) (equivalent to independent per‑column Bernoullis over \(N\) opportunities).
- **Readout rule (ties‑only zone at δt=0):** if a trial is **unmarked**, both outputs are constructive ⇒ **PF/Born fair tie** (coherent). If **marked**, treat as which‑path encoded ⇒ **neutral 50/50**. This makes the measured visibility amplitude at δt=0 proportional to the **unmarked fraction** \(q=(1-p)^N\).
- **Metrics:** computes `vis`, baseline `vis0`, normalized visibility `vis_norm=vis/vis0`, predictions `pred_binom=(1-p)**N` and `pred_exp=exp(-p*N)`, and `neutral_rate`. Also runs linear fits:
  - fixed **N**: fit \(y=-\ln(\text{vis\_norm})\) vs **p**
  - fixed **p**: fit \(y=-\ln(\text{vis\_norm})\) vs **N**
- **Pass criteria:** RMSE vs \((1-p)^N\) and \(e^{-pN}\) < 0.02; slopes within ±10% and \(R^2\ge0.98\) for all fits; guardrails all **true**.

## CLI

```bash
python run.py --outdir outputs --k-per-seed 50000 --seeds 101 202 303   --p 0 0.005 0.01 0.02 0.04 0.06 0.08 0.10   --N 10 25 50 100
```

Use `-h/--help` for all options.

## Reproducibility

- RNG family: **PCG64**; seeds default to **101, 202, 303**.
- Per grid point we simulate **K=50,000** trials per seed (150,000 total).
- The outputs in `outputs/` were generated with these exact defaults.

## Contract notes

- **No curves/weights in acceptance**; PF/Born used **only** when both outputs are constructive *and* no mark is present for that trial (ties‑only). Marks are pure booleans.
- **No‑skip** composition is respected in this reduced benchmark (neighbor‑only semantics); ticks are normalized counts of acts/M.
- CRA labels are tracked notionally but **not** used to steer acceptance here.

For a detailed specification of the Present‑Act V2.1 contract (axioms, gates, equality fit, ratio‑lex, ties‑only PF/Born, budgets, audits, diagnostics separation), see the theory document that this repo follows.

## License

MIT — see `LICENSE`.
